VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Signature Appearance"
   ClientHeight    =   2580
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   4968
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2580
   ScaleWidth      =   4968
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create and view PDF file"
      Height          =   735
      Left            =   1200
      TabIndex        =   0
      Top             =   960
      Width           =   2535
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "This example signs a document digitally with a self sign certificate and creates a user defined signature field."
      Height          =   390
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   4800
      WordWrap        =   -1  'True
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = True ' We break processing if an error occurred!
End Sub

Private Sub Command1_Click()
   ' Error messages and warnings are passed to the error event function.
   If Not pdf.CreateNewPDF(vbNullString) Then ' The output file is opened later
      Exit Sub
   End If

   Call pdf.Append
      Call pdf.SetFont("Arial", fsNone, 14#, True, cp1252)
      Call pdf.WriteFText(taLeft, "This file is digitally signed with a self sign certificate." & _
         "The appearance of the signature field is created with normal DynaPDF functions. However, it " & _
         "would also be possible to import a PDF page, an EMF file, or an image into the " & _
         "appearance template." & Chr(13) & Chr(13) & _
         "When creating an individual signature appearance make sure to place the validation icon " & _
         "properly with PlaceSigFieldValidateIcon(). The appearance of the validation icon " & _
         "depends on the Acrobat version with which the file is opened. However, the unscaled size " & _
         "of that icon is always 100.0 x 100.0 Units. It can be scaled to every size you want " & _
         "but it is usually best to preserve the aspect ratio and the icon must be placed fully " & _
         "inside the appearance template.")
   
      ' ---------------------- Signature field appearance ----------------------
      
      Dim SigField As Long
      Dim sh As Long
   
      SigField = pdf.CreateSigField("Signature", -1, 200#, 500#, 200#, 80#)
      Call pdf.SetFieldColor(SigField, fcBorderColor, csDeviceRGB, NO_COLOR)
      ' Place the validation icon on the left side of the signature field.
      Call pdf.PlaceSigFieldValidateIcon(SigField, 0#, 15#, 50#, 50#)
   
      '   This function creates a template into which you can draw whatever you want. The template
      '   is already opened when calling the function; it must be closed when finish with EndTemplate().
      '   An appearance template of a signature field is reserved for this field. It must not be placed
      '   on a page!
      '
      '   In addition, it makes no sense to create an appearance template when the file is not digitally
      '   signed later. Empty signature fields cannot contain a user defined appearance.
      Call pdf.CreateSigFieldAP(SigField)
   
         Call pdf.SaveGraphicState
            Call pdf.Rectangle(0#, 0#, 200#, 80#, fmNoFill)
            Call pdf.ClipPath(cmWinding, fmNoFill)
            sh = pdf.CreateAxialShading(0#, 0#, 200#, 0#, 0.5, RGB(120, 120, 220), vbWhite, True, True)
            Call pdf.ApplyShading(sh)
         Call pdf.RestoreGraphicState
      
         Call pdf.SaveGraphicState
            Call pdf.Ellipse(50.5, 1#, 148.5, 78#, fmNoFill)
            Call pdf.ClipPath(cmWinding, fmNoFill)
            sh = pdf.CreateAxialShading(0#, 0#, 0#, 78#, 2#, vbWhite, RGB(120, 120, 220), True, True)
            Call pdf.ApplyShading(sh)
         Call pdf.RestoreGraphicState
      
         Call pdf.SetFont("Arial", fsBold Or fsUnderlined, 11#, True, cp1252)
         Call pdf.SetFillColor(RGB(120, 120, 220))
         Call pdf.WriteFTextEx(50#, 60#, 150#, -1#, taCenter, "Digitally signed by:")
         Call pdf.SetFont("Arial", fsBold Or fsItalic, 18#, True, cp1252)
         Call pdf.SetFillColor(RGB(100, 100, 200))
         Call pdf.WriteFTextEx(50#, 45#, 150#, -1#, taCenter, "DynaPDF")
   
      Call pdf.EndTemplate ' Close the appearance template.

   ' ------------------------------------------------------------------------

   Call pdf.EndPage ' Close the open page

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim outFile As String
      outFile = App.Path + "\out.pdf"
      If Not pdf.OpenOutputFile(outFile) Then
         pdf.FreePDF
         Exit Sub
      End If
      If Not pdf.CloseAndSignFile("../../test_files/test_cert.pfx", "123456", "Test", "") Then
         ' Note: If the certificate cannot be found or when using a wrong password the PDF file is still
         ' in memory. This is required to enable entering another password or certificate file.
         pdf.FreePDF
      Else
         ShellExecuteA Me.hWnd, "open", outFile, vbNullString, vbNullString, 1
      End If
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub

